using System;
using System.Collections.Generic;
using System.Text;

namespace Generics1
{
   public class MethodTest
   {
      public static bool IsGreater<TOperand>(TOperand op1, TOperand op2)
        where TOperand : IComparable
      {
         return (op1.CompareTo(op2) > 0);
      }
   }

   public class MethodTest2<TItem> where TItem : IComparable
   {
      public bool IsGreater(TItem op1, TItem op2)
      {
         return MethodTest.IsGreater<TItem>(op1, op2);
      }
   }

   class MainClass
   {
      public static void Main(string[] args)
      {
         Console.WriteLine(
           string.Format("Czy 2 jest wieksze od 3? : {0}",
           MethodTest.IsGreater<int>(2, 3) ? "Prawda" : "Falsz"));

         MethodTest2<string> m2 = new MethodTest2<string>();
         Console.WriteLine(
           string.Format("Czy Z jest wieksze niz A? : {0}",
           m2.IsGreater("Z", "A") ? "Prawda" : "Falsz"));

         Console.WriteLine(
           string.Format("Test parametrw o niejawnym typie, 2 > 3 : {0}",
           MethodTest.IsGreater(2, 3) ? "Prawda" : "Falsz"));

         Console.ReadLine();

      }
   }
}
